/*
 * Copyright (c) 1999-2001 Lutris Technologies, Inc. All Rights
 * Reserved.
 * 
 * This source code file is distributed by Lutris Technologies, Inc. for
 * use only by licensed users of product(s) that include this source
 * file. Use of this source file or the software that uses it is covered
 * by the terms and conditions of the Lutris Enhydra Development License
 * Agreement included with this product.
 * 
 * This Software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
 * ANY KIND, either express or implied. See the License for the specific terms
 * governing rights and limitations under the License.
 * 
 * Contributor(s):
 * 
 * $Id: ParseEvent.java,v 1.1.1.1 2001/01/05 05:11:17 sese0235 Exp $
 */

package de.kxml.parser;

import java.util.*;
import java.io.IOException;
import de.kxml.*;

/**
 * Abstract superclass for all pull parser events.  In order to avoid
 * some typecasts, this class already provides most of the content
 * access methods filled in the specialized subclasses.
 */
public abstract class ParseEvent {
    int lineNumber = -1;

    /**
     * returns the line number of the event
     */
    public int getLineNumber() {
	return lineNumber;
    } 

    /**
     * returns the event type integer constant assigned to this
     * event.  Possible event types are Xml.START_TAG, Xml.END_TAG,
     * Xml.TEXT, Xml.PROCESSING_INSTRUCTION, Xml.COMMENT,
     * Xml.DOCTYPE, and Xml.END_DOCUMENT
     */
    public abstract int getType();

    /**
     * returns true if the event is the matching endtag, false if the
     * event is an empty(!) text event, a comment or a processing
     * instruction.  Throws an exception if the event is not
     * ignoreable. Useful in the default handler of a case construct
     * when all relevant events are already picked out
     */
    public abstract boolean endCheck(StartTag start);

    /**
     * sets the line number of the event. Used by the parser only.
     */
    public void setLineNumber(int lineNumber) {
	this.lineNumber = lineNumber;
    } 

    /**
     * In the event type is START_TAG, this method returns the attribute
     * at the given index position. For all other event
     * types, null is returned
     */
    public Attribute getAttribute(int index) {
	return null;
    } 

    /**
     * convenience method for getAttribute (null, name).
     */
    public Attribute getAttribute(String name) {
	return null;
    } 

    /**
     * If the event type is START_TAG, the local attribute with the
     * given namespace and name is returned.  For all other event
     * types, the return value is null.
     */
    public Attribute getAttribute(String namespace, String name) {
	return null;
    } 

    /**
     * If the event type is START_TAG, the number of attributes is
     * returned. For all other event types, the return value is null
     */
    public int getAttributeCount() {
	return 0;
    } 

    /**
     * returns the attribute vector. Returns null if not
     * instance of startTag
     */
    public Vector getAttributes() {
	return null;
    } 

    /**
     * returns the (local) name of the element started if
     * instance of StartTag, null otherwise.
     */
    public String getName() {
	return null;
    } 

    /**
     * returns namespace if instance of StartTag, null
     * otherwise.
     */
    public String getNamespace() {
	return null;
    } 

    /**
     * returns the value of the attribute with the given name,
     * or null, if not instanceof StartTag or if not existing
     */
    public String getValue(String attrname) {
	return null;
    } 

    /**
     * If the event type is TEXT, PROCESSING_INSTRUCTION,
     * or DOCTYPE, the corresponding string is returned. For
     * all othe event types, null is returned.
     */
    public String getText() {
	return null;
    } 

}

